/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.MetalBumps;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalToolBarUI;
import javax.swing.plaf.metal.MetalUtils;
import javax.swing.text.JTextComponent;
import sun.swing.StringUIClientPropertyKey;
import sun.swing.SwingUtilities2;

public class MetalBorders {
    static Object NO_BUTTON_ROLLOVER = new StringUIClientPropertyKey("NoButtonRollover");
    private static Border buttonBorder;
    private static Border textBorder;
    private static Border textFieldBorder;
    private static Border toggleButtonBorder;

    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new BorderUIResource.CompoundBorderUIResource(new ButtonBorder(), new BasicBorders.MarginBorder());
        }
        return buttonBorder;
    }

    public static Border getTextBorder() {
        if (textBorder == null) {
            textBorder = new BorderUIResource.CompoundBorderUIResource(new Flush3DBorder(), new BasicBorders.MarginBorder());
        }
        return textBorder;
    }

    public static Border getTextFieldBorder() {
        if (textFieldBorder == null) {
            textFieldBorder = new BorderUIResource.CompoundBorderUIResource(new TextFieldBorder(), new BasicBorders.MarginBorder());
        }
        return textFieldBorder;
    }

    public static Border getToggleButtonBorder() {
        if (toggleButtonBorder == null) {
            toggleButtonBorder = new BorderUIResource.CompoundBorderUIResource(new ToggleButtonBorder(), new BasicBorders.MarginBorder());
        }
        return toggleButtonBorder;
    }

    public static Border getDesktopIconBorder() {
        return new BorderUIResource.CompoundBorderUIResource(new LineBorder(MetalLookAndFeel.getControlDarkShadow(), 1), new MatteBorder(2, 2, 1, 2, MetalLookAndFeel.getControl()));
    }

    static Border getToolBarRolloverBorder() {
        if (MetalLookAndFeel.usingOcean()) {
            return new CompoundBorder(new ButtonBorder(), new RolloverMarginBorder());
        }
        return new CompoundBorder(new RolloverButtonBorder(), new RolloverMarginBorder());
    }

    static Border getToolBarNonrolloverBorder() {
        if (MetalLookAndFeel.usingOcean()) {
            new CompoundBorder(new ButtonBorder(), new RolloverMarginBorder());
        }
        return new CompoundBorder(new ButtonBorder(), new RolloverMarginBorder());
    }

    public static class ButtonBorder
    extends AbstractBorder
    implements UIResource {
        protected static Insets borderInsets = new Insets(3, 3, 3, 3);

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (!(component instanceof AbstractButton)) {
                return;
            }
            if (MetalLookAndFeel.usingOcean()) {
                this.paintOceanBorder(component, graphics, n, n2, n3, n4);
                return;
            }
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (buttonModel.isEnabled()) {
                boolean bl;
                boolean bl2 = buttonModel.isPressed() && buttonModel.isArmed();
                boolean bl3 = bl = abstractButton instanceof JButton && ((JButton)abstractButton).isDefaultButton();
                if (bl2 && bl) {
                    MetalUtils.drawDefaultButtonPressedBorder(graphics, n, n2, n3, n4);
                } else if (bl2) {
                    MetalUtils.drawPressed3DBorder(graphics, n, n2, n3, n4);
                } else if (bl) {
                    MetalUtils.drawDefaultButtonBorder(graphics, n, n2, n3, n4, false);
                } else {
                    MetalUtils.drawButtonBorder(graphics, n, n2, n3, n4, false);
                }
            } else {
                MetalUtils.drawDisabledBorder(graphics, n, n2, n3 - 1, n4 - 1);
            }
        }

        private void paintOceanBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = ((AbstractButton)component).getModel();
            graphics.translate(n, n2);
            if (MetalUtils.isToolBarButton(abstractButton)) {
                if (buttonModel.isEnabled()) {
                    if (buttonModel.isPressed()) {
                        graphics.setColor(MetalLookAndFeel.getWhite());
                        graphics.fillRect(1, n4 - 1, n3 - 1, 1);
                        graphics.fillRect(n3 - 1, 1, 1, n4 - 1);
                        graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                        graphics.drawRect(0, 0, n3 - 2, n4 - 2);
                        graphics.fillRect(1, 1, n3 - 3, 1);
                    } else if (buttonModel.isSelected() || buttonModel.isRollover()) {
                        graphics.setColor(MetalLookAndFeel.getWhite());
                        graphics.fillRect(1, n4 - 1, n3 - 1, 1);
                        graphics.fillRect(n3 - 1, 1, 1, n4 - 1);
                        graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                        graphics.drawRect(0, 0, n3 - 2, n4 - 2);
                    } else {
                        graphics.setColor(MetalLookAndFeel.getWhite());
                        graphics.drawRect(1, 1, n3 - 2, n4 - 2);
                        graphics.setColor(UIManager.getColor("Button.toolBarBorderBackground"));
                        graphics.drawRect(0, 0, n3 - 2, n4 - 2);
                    }
                } else {
                    graphics.setColor(UIManager.getColor("Button.disabledToolBarBorderBackground"));
                    graphics.drawRect(0, 0, n3 - 2, n4 - 2);
                }
            } else if (buttonModel.isEnabled()) {
                boolean bl = buttonModel.isPressed();
                boolean bl2 = buttonModel.isArmed();
                if (component instanceof JButton && ((JButton)component).isDefaultButton()) {
                    graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                    graphics.drawRect(0, 0, n3 - 1, n4 - 1);
                    graphics.drawRect(1, 1, n3 - 3, n4 - 3);
                } else if (bl) {
                    graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                    graphics.fillRect(0, 0, n3, 2);
                    graphics.fillRect(0, 2, 2, n4 - 2);
                    graphics.fillRect(n3 - 1, 1, 1, n4 - 1);
                    graphics.fillRect(1, n4 - 1, n3 - 2, 1);
                } else if (buttonModel.isRollover() && abstractButton.getClientProperty(NO_BUTTON_ROLLOVER) == null) {
                    graphics.setColor(MetalLookAndFeel.getPrimaryControl());
                    graphics.drawRect(0, 0, n3 - 1, n4 - 1);
                    graphics.drawRect(2, 2, n3 - 5, n4 - 5);
                    graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                    graphics.drawRect(1, 1, n3 - 3, n4 - 3);
                } else {
                    graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                    graphics.drawRect(0, 0, n3 - 1, n4 - 1);
                }
            } else {
                graphics.setColor(MetalLookAndFeel.getInactiveControlTextColor());
                graphics.drawRect(0, 0, n3 - 1, n4 - 1);
                if (component instanceof JButton && ((JButton)component).isDefaultButton()) {
                    graphics.drawRect(1, 1, n3 - 3, n4 - 3);
                }
            }
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.set(3, 3, 3, 3);
            return insets;
        }
    }

    static class DialogBorder
    extends AbstractBorder
    implements UIResource {
        private static final int corner = 14;

        DialogBorder() {
        }

        protected Color getActiveBackground() {
            return MetalLookAndFeel.getPrimaryControlDarkShadow();
        }

        protected Color getActiveHighlight() {
            return MetalLookAndFeel.getPrimaryControlShadow();
        }

        protected Color getActiveShadow() {
            return MetalLookAndFeel.getPrimaryControlInfo();
        }

        protected Color getInactiveBackground() {
            return MetalLookAndFeel.getControlDarkShadow();
        }

        protected Color getInactiveHighlight() {
            return MetalLookAndFeel.getControlShadow();
        }

        protected Color getInactiveShadow() {
            return MetalLookAndFeel.getControlInfo();
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color;
            Color color2;
            Color color3;
            Window window = SwingUtilities.getWindowAncestor(component);
            if (window != null && window.isActive()) {
                color3 = this.getActiveBackground();
                color2 = this.getActiveHighlight();
                color = this.getActiveShadow();
            } else {
                color3 = this.getInactiveBackground();
                color2 = this.getInactiveHighlight();
                color = this.getInactiveShadow();
            }
            graphics.setColor(color3);
            graphics.drawLine(n + 1, n2 + 0, n + n3 - 2, n2 + 0);
            graphics.drawLine(n + 0, n2 + 1, n + 0, n2 + n4 - 2);
            graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + n4 - 2);
            graphics.drawLine(n + 1, n2 + n4 - 1, n + n3 - 2, n2 + n4 - 1);
            for (int i = 1; i < 5; ++i) {
                graphics.drawRect(n + i, n2 + i, n3 - i * 2 - 1, n4 - i * 2 - 1);
            }
            if (window instanceof Dialog && ((Dialog)window).isResizable()) {
                graphics.setColor(color2);
                graphics.drawLine(15, 3, n3 - 14, 3);
                graphics.drawLine(3, 15, 3, n4 - 14);
                graphics.drawLine(n3 - 2, 15, n3 - 2, n4 - 14);
                graphics.drawLine(15, n4 - 2, n3 - 14, n4 - 2);
                graphics.setColor(color);
                graphics.drawLine(14, 2, n3 - 14 - 1, 2);
                graphics.drawLine(2, 14, 2, n4 - 14 - 1);
                graphics.drawLine(n3 - 3, 14, n3 - 3, n4 - 14 - 1);
                graphics.drawLine(14, n4 - 3, n3 - 14 - 1, n4 - 3);
            }
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.set(5, 5, 5, 5);
            return insets;
        }
    }

    static class ErrorDialogBorder
    extends DialogBorder
    implements UIResource {
        ErrorDialogBorder() {
        }

        @Override
        protected Color getActiveBackground() {
            return UIManager.getColor("OptionPane.errorDialog.border.background");
        }
    }

    public static class Flush3DBorder
    extends AbstractBorder
    implements UIResource {
        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (component.isEnabled()) {
                MetalUtils.drawFlush3DBorder(graphics, n, n2, n3, n4);
            } else {
                MetalUtils.drawDisabledBorder(graphics, n, n2, n3, n4);
            }
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.set(2, 2, 2, 2);
            return insets;
        }
    }

    static class FrameBorder
    extends AbstractBorder
    implements UIResource {
        private static final int corner = 14;

        FrameBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            ColorUIResource colorUIResource;
            ColorUIResource colorUIResource2;
            ColorUIResource colorUIResource3;
            Window window = SwingUtilities.getWindowAncestor(component);
            if (window != null && window.isActive()) {
                colorUIResource3 = MetalLookAndFeel.getPrimaryControlDarkShadow();
                colorUIResource2 = MetalLookAndFeel.getPrimaryControlShadow();
                colorUIResource = MetalLookAndFeel.getPrimaryControlInfo();
            } else {
                colorUIResource3 = MetalLookAndFeel.getControlDarkShadow();
                colorUIResource2 = MetalLookAndFeel.getControlShadow();
                colorUIResource = MetalLookAndFeel.getControlInfo();
            }
            graphics.setColor(colorUIResource3);
            graphics.drawLine(n + 1, n2 + 0, n + n3 - 2, n2 + 0);
            graphics.drawLine(n + 0, n2 + 1, n + 0, n2 + n4 - 2);
            graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + n4 - 2);
            graphics.drawLine(n + 1, n2 + n4 - 1, n + n3 - 2, n2 + n4 - 1);
            for (int i = 1; i < 5; ++i) {
                graphics.drawRect(n + i, n2 + i, n3 - i * 2 - 1, n4 - i * 2 - 1);
            }
            if (window instanceof Frame && ((Frame)window).isResizable()) {
                graphics.setColor(colorUIResource2);
                graphics.drawLine(15, 3, n3 - 14, 3);
                graphics.drawLine(3, 15, 3, n4 - 14);
                graphics.drawLine(n3 - 2, 15, n3 - 2, n4 - 14);
                graphics.drawLine(15, n4 - 2, n3 - 14, n4 - 2);
                graphics.setColor(colorUIResource);
                graphics.drawLine(14, 2, n3 - 14 - 1, 2);
                graphics.drawLine(2, 14, 2, n4 - 14 - 1);
                graphics.drawLine(n3 - 3, 14, n3 - 3, n4 - 14 - 1);
                graphics.drawLine(14, n4 - 3, n3 - 14 - 1, n4 - 3);
            }
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.set(5, 5, 5, 5);
            return insets;
        }
    }

    public static class InternalFrameBorder
    extends AbstractBorder
    implements UIResource {
        private static final int corner = 14;

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            ColorUIResource colorUIResource;
            ColorUIResource colorUIResource2;
            ColorUIResource colorUIResource3;
            if (component instanceof JInternalFrame && ((JInternalFrame)component).isSelected()) {
                colorUIResource3 = MetalLookAndFeel.getPrimaryControlDarkShadow();
                colorUIResource2 = MetalLookAndFeel.getPrimaryControlShadow();
                colorUIResource = MetalLookAndFeel.getPrimaryControlInfo();
            } else {
                colorUIResource3 = MetalLookAndFeel.getControlDarkShadow();
                colorUIResource2 = MetalLookAndFeel.getControlShadow();
                colorUIResource = MetalLookAndFeel.getControlInfo();
            }
            graphics.setColor(colorUIResource3);
            graphics.drawLine(1, 0, n3 - 2, 0);
            graphics.drawLine(0, 1, 0, n4 - 2);
            graphics.drawLine(n3 - 1, 1, n3 - 1, n4 - 2);
            graphics.drawLine(1, n4 - 1, n3 - 2, n4 - 1);
            for (int i = 1; i < 5; ++i) {
                graphics.drawRect(n + i, n2 + i, n3 - i * 2 - 1, n4 - i * 2 - 1);
            }
            if (component instanceof JInternalFrame && ((JInternalFrame)component).isResizable()) {
                graphics.setColor(colorUIResource2);
                graphics.drawLine(15, 3, n3 - 14, 3);
                graphics.drawLine(3, 15, 3, n4 - 14);
                graphics.drawLine(n3 - 2, 15, n3 - 2, n4 - 14);
                graphics.drawLine(15, n4 - 2, n3 - 14, n4 - 2);
                graphics.setColor(colorUIResource);
                graphics.drawLine(14, 2, n3 - 14 - 1, 2);
                graphics.drawLine(2, 14, 2, n4 - 14 - 1);
                graphics.drawLine(n3 - 3, 14, n3 - 3, n4 - 14 - 1);
                graphics.drawLine(14, n4 - 3, n3 - 14 - 1, n4 - 3);
            }
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.set(5, 5, 5, 5);
            return insets;
        }
    }

    public static class MenuBarBorder
    extends AbstractBorder
    implements UIResource {
        protected static Insets borderInsets = new Insets(1, 0, 1, 0);

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            if (MetalLookAndFeel.usingOcean()) {
                if (component instanceof JMenuBar && !MetalToolBarUI.doesMenuBarBorderToolBar((JMenuBar)component)) {
                    graphics.setColor(MetalLookAndFeel.getControl());
                    SwingUtilities2.drawHLine(graphics, 0, n3 - 1, n4 - 2);
                    graphics.setColor(UIManager.getColor("MenuBar.borderColor"));
                    SwingUtilities2.drawHLine(graphics, 0, n3 - 1, n4 - 1);
                }
            } else {
                graphics.setColor(MetalLookAndFeel.getControlShadow());
                SwingUtilities2.drawHLine(graphics, 0, n3 - 1, n4 - 1);
            }
            graphics.translate(-n, -n2);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            if (MetalLookAndFeel.usingOcean()) {
                insets.set(0, 0, 2, 0);
            } else {
                insets.set(1, 0, 1, 0);
            }
            return insets;
        }
    }

    public static class MenuItemBorder
    extends AbstractBorder
    implements UIResource {
        protected static Insets borderInsets = new Insets(2, 2, 2, 2);

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (!(component instanceof JMenuItem)) {
                return;
            }
            JMenuItem jMenuItem = (JMenuItem)component;
            ButtonModel buttonModel = jMenuItem.getModel();
            graphics.translate(n, n2);
            if (component.getParent() instanceof JMenuBar) {
                if (buttonModel.isArmed() || buttonModel.isSelected()) {
                    graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                    graphics.drawLine(0, 0, n3 - 2, 0);
                    graphics.drawLine(0, 0, 0, n4 - 1);
                    graphics.drawLine(n3 - 2, 2, n3 - 2, n4 - 1);
                    graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
                    graphics.drawLine(n3 - 1, 1, n3 - 1, n4 - 1);
                    graphics.setColor(MetalLookAndFeel.getMenuBackground());
                    graphics.drawLine(n3 - 1, 0, n3 - 1, 0);
                }
            } else if (buttonModel.isArmed() || component instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
                graphics.drawLine(0, 0, n3 - 1, 0);
                graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
                graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
            } else {
                graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
                graphics.drawLine(0, 0, 0, n4 - 1);
            }
            graphics.translate(-n, -n2);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.set(2, 2, 2, 2);
            return insets;
        }
    }

    public static class OptionDialogBorder
    extends AbstractBorder
    implements UIResource {
        int titleHeight = 0;

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Object object;
            graphics.translate(n, n2);
            int n5 = -1;
            if (component instanceof JInternalFrame && (object = ((JInternalFrame)component).getClientProperty("JInternalFrame.messageType")) instanceof Integer) {
                n5 = (Integer)object;
            }
            switch (n5) {
                case 0: {
                    object = UIManager.getColor("OptionPane.errorDialog.border.background");
                    break;
                }
                case 3: {
                    object = UIManager.getColor("OptionPane.questionDialog.border.background");
                    break;
                }
                case 2: {
                    object = UIManager.getColor("OptionPane.warningDialog.border.background");
                    break;
                }
                default: {
                    object = MetalLookAndFeel.getPrimaryControlDarkShadow();
                }
            }
            graphics.setColor((Color)object);
            graphics.drawLine(1, 0, n3 - 2, 0);
            graphics.drawLine(0, 1, 0, n4 - 2);
            graphics.drawLine(n3 - 1, 1, n3 - 1, n4 - 2);
            graphics.drawLine(1, n4 - 1, n3 - 2, n4 - 1);
            for (int i = 1; i < 3; ++i) {
                graphics.drawRect(i, i, n3 - i * 2 - 1, n4 - i * 2 - 1);
            }
            graphics.translate(-n, -n2);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.set(3, 3, 3, 3);
            return insets;
        }
    }

    public static class PaletteBorder
    extends AbstractBorder
    implements UIResource {
        int titleHeight = 0;

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            graphics.drawLine(0, 1, 0, n4 - 2);
            graphics.drawLine(1, n4 - 1, n3 - 2, n4 - 1);
            graphics.drawLine(n3 - 1, 1, n3 - 1, n4 - 2);
            graphics.drawLine(1, 0, n3 - 2, 0);
            graphics.drawRect(1, 1, n3 - 3, n4 - 3);
            graphics.translate(-n, -n2);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.set(1, 1, 1, 1);
            return insets;
        }
    }

    public static class PopupMenuBorder
    extends AbstractBorder
    implements UIResource {
        protected static Insets borderInsets = new Insets(3, 1, 2, 1);

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            graphics.drawRect(0, 0, n3 - 1, n4 - 1);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            graphics.drawLine(1, 1, n3 - 2, 1);
            graphics.drawLine(1, 2, 1, 2);
            graphics.drawLine(1, n4 - 2, 1, n4 - 2);
            graphics.translate(-n, -n2);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.set(3, 1, 2, 1);
            return insets;
        }
    }

    static class QuestionDialogBorder
    extends DialogBorder
    implements UIResource {
        QuestionDialogBorder() {
        }

        @Override
        protected Color getActiveBackground() {
            return UIManager.getColor("OptionPane.questionDialog.border.background");
        }
    }

    public static class RolloverButtonBorder
    extends ButtonBorder {
        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (buttonModel.isRollover() && (!buttonModel.isPressed() || buttonModel.isArmed())) {
                super.paintBorder(component, graphics, n, n2, n3, n4);
            }
        }
    }

    static class RolloverMarginBorder
    extends EmptyBorder {
        public RolloverMarginBorder() {
            super(3, 3, 3, 3);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2 = null;
            if (component instanceof AbstractButton) {
                insets2 = ((AbstractButton)component).getMargin();
            }
            if (insets2 == null || insets2 instanceof UIResource) {
                insets.left = this.left;
                insets.top = this.top;
                insets.right = this.right;
                insets.bottom = this.bottom;
            } else {
                insets.left = insets2.left;
                insets.top = insets2.top;
                insets.right = insets2.right;
                insets.bottom = insets2.bottom;
            }
            return insets;
        }
    }

    public static class ScrollPaneBorder
    extends AbstractBorder
    implements UIResource {
        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (!(component instanceof JScrollPane)) {
                return;
            }
            JScrollPane jScrollPane = (JScrollPane)component;
            JViewport jViewport = jScrollPane.getColumnHeader();
            int n5 = 0;
            if (jViewport != null) {
                n5 = jViewport.getHeight();
            }
            JViewport jViewport2 = jScrollPane.getRowHeader();
            int n6 = 0;
            if (jViewport2 != null) {
                n6 = jViewport2.getWidth();
            }
            graphics.translate(n, n2);
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            graphics.drawRect(0, 0, n3 - 2, n4 - 2);
            graphics.setColor(MetalLookAndFeel.getControlHighlight());
            graphics.drawLine(n3 - 1, 1, n3 - 1, n4 - 1);
            graphics.drawLine(1, n4 - 1, n3 - 1, n4 - 1);
            graphics.setColor(MetalLookAndFeel.getControl());
            graphics.drawLine(n3 - 2, 2 + n5, n3 - 2, 2 + n5);
            graphics.drawLine(1 + n6, n4 - 2, 1 + n6, n4 - 2);
            graphics.translate(-n, -n2);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.set(1, 1, 2, 2);
            return insets;
        }
    }

    public static class TableHeaderBorder
    extends AbstractBorder {
        protected Insets editorBorderInsets = new Insets(2, 2, 2, 0);

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            graphics.drawLine(n3 - 1, 0, n3 - 1, n4 - 1);
            graphics.drawLine(1, n4 - 1, n3 - 1, n4 - 1);
            graphics.setColor(MetalLookAndFeel.getControlHighlight());
            graphics.drawLine(0, 0, n3 - 2, 0);
            graphics.drawLine(0, 0, 0, n4 - 2);
            graphics.translate(-n, -n2);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.set(2, 2, 2, 0);
            return insets;
        }
    }

    public static class TextFieldBorder
    extends Flush3DBorder {
        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (!(component instanceof JTextComponent)) {
                if (component.isEnabled()) {
                    MetalUtils.drawFlush3DBorder(graphics, n, n2, n3, n4);
                } else {
                    MetalUtils.drawDisabledBorder(graphics, n, n2, n3, n4);
                }
                return;
            }
            if (component.isEnabled() && ((JTextComponent)component).isEditable()) {
                MetalUtils.drawFlush3DBorder(graphics, n, n2, n3, n4);
            } else {
                MetalUtils.drawDisabledBorder(graphics, n, n2, n3, n4);
            }
        }
    }

    public static class ToggleButtonBorder
    extends ButtonBorder {
        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (MetalLookAndFeel.usingOcean()) {
                if (buttonModel.isArmed() || !abstractButton.isEnabled()) {
                    super.paintBorder(component, graphics, n, n2, n3, n4);
                } else {
                    graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                    graphics.drawRect(0, 0, n3 - 1, n4 - 1);
                }
                return;
            }
            if (!component.isEnabled()) {
                MetalUtils.drawDisabledBorder(graphics, n, n2, n3 - 1, n4 - 1);
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                MetalUtils.drawPressed3DBorder(graphics, n, n2, n3, n4);
            } else if (buttonModel.isSelected()) {
                MetalUtils.drawDark3DBorder(graphics, n, n2, n3, n4);
            } else {
                MetalUtils.drawFlush3DBorder(graphics, n, n2, n3, n4);
            }
        }
    }

    public static class ToolBarBorder
    extends AbstractBorder
    implements UIResource,
    SwingConstants {
        protected MetalBumps bumps = new MetalBumps(10, 10, MetalLookAndFeel.getControlHighlight(), MetalLookAndFeel.getControlDarkShadow(), UIManager.getColor("ToolBar.background"));

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (!(component instanceof JToolBar)) {
                return;
            }
            graphics.translate(n, n2);
            if (((JToolBar)component).isFloatable()) {
                if (((JToolBar)component).getOrientation() == 0) {
                    int n5 = MetalLookAndFeel.usingOcean() ? -1 : 0;
                    this.bumps.setBumpArea(10, n4 - 4);
                    if (MetalUtils.isLeftToRight(component)) {
                        this.bumps.paintIcon(component, graphics, 2, 2 + n5);
                    } else {
                        this.bumps.paintIcon(component, graphics, n3 - 12, 2 + n5);
                    }
                } else {
                    this.bumps.setBumpArea(n3 - 4, 10);
                    this.bumps.paintIcon(component, graphics, 2, 2);
                }
            }
            if (((JToolBar)component).getOrientation() == 0 && MetalLookAndFeel.usingOcean()) {
                graphics.setColor(MetalLookAndFeel.getControl());
                graphics.drawLine(0, n4 - 2, n3, n4 - 2);
                graphics.setColor(UIManager.getColor("ToolBar.borderColor"));
                graphics.drawLine(0, n4 - 1, n3, n4 - 1);
            }
            graphics.translate(-n, -n2);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2;
            if (MetalLookAndFeel.usingOcean()) {
                insets.set(1, 2, 3, 2);
            } else {
                insets.right = 2;
                insets.bottom = 2;
                insets.left = 2;
                insets.top = 2;
            }
            if (!(component instanceof JToolBar)) {
                return insets;
            }
            if (((JToolBar)component).isFloatable()) {
                if (((JToolBar)component).getOrientation() == 0) {
                    if (component.getComponentOrientation().isLeftToRight()) {
                        insets.left = 16;
                    } else {
                        insets.right = 16;
                    }
                } else {
                    insets.top = 16;
                }
            }
            if ((insets2 = ((JToolBar)component).getMargin()) != null) {
                insets.left += insets2.left;
                insets.top += insets2.top;
                insets.right += insets2.right;
                insets.bottom += insets2.bottom;
            }
            return insets;
        }
    }

    static class WarningDialogBorder
    extends DialogBorder
    implements UIResource {
        WarningDialogBorder() {
        }

        @Override
        protected Color getActiveBackground() {
            return UIManager.getColor("OptionPane.warningDialog.border.background");
        }
    }
}

